/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.bootstrap.service;

import java.util.concurrent.locks.ReentrantLock;
import ru.smclabs.bootstrap.Bootstrap;
import ru.smclabs.bootstrap.service.AbstractService;
import ru.smclabs.bootstrap.service.resource.ResourcesUpdateTask;
import ru.smclabs.slauncher.resources.exception.ResourceException;

public class ResourcesService
extends AbstractService {
    private final ReentrantLock lock = new ReentrantLock();
    private volatile ResourcesUpdateTask currentTask;

    public ResourcesService(Bootstrap bootstrap) {
        super(bootstrap);
    }

    public void createTask() {
        this.lock.lock();
        try {
            if (this.currentTask != null && !this.currentTask.isCancelled()) {
                throw new ResourceException("Resource service is busy!");
            }
            this.currentTask = new ResourcesUpdateTask(this, this.getBootstrap().getGuiService().getPanelBackground().getPanelUpdate());
            this.currentTask.start();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void cancelTask() {
        this.lock.lock();
        try {
            if (this.currentTask == null) {
                return;
            }
            this.currentTask.interrupt();
            this.currentTask = null;
        }
        finally {
            this.lock.unlock();
        }
    }
}

