/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.bootstrap.service.gui.component;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.AbstractBorder;
import ru.smclabs.bootstrap.service.gui.ThemeManager;

public class BorderBackground
extends AbstractBorder {
    private final Insets insets;
    private final BasicStroke stroke = new BasicStroke(1.0f);
    private final RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private final Color borderColor;

    public BorderBackground(ThemeManager themeManager) {
        this.insets = new Insets(0, 0, 0, 0);
        this.borderColor = themeManager.getColor("bg-border");
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return this.getBorderInsets(c);
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int x, int y, int width, int height) {
        RoundRectangle2D.Double roundRectangle = new RoundRectangle2D.Double(0.0, 0.0, (float)width - this.stroke.getLineWidth(), (float)height - this.stroke.getLineWidth(), 26.703537555513243, 26.703537555513243);
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setPaint(this.borderColor);
        g2.setRenderingHints(this.hints);
        g2.setStroke(this.stroke);
        g2.draw(new Area(roundRectangle));
    }
}

