/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.bootstrap.service.gui.component.widget;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.JComponent;
import ru.smclabs.bootstrap.service.gui.ThemeManager;
import ru.smclabs.bootstrap.service.gui.panel.PanelUpdate;
import ru.smclabs.bootstrap.util.LocalResourceHelper;

public class FileDownloading
extends JComponent {
    private final ThemeManager themeManager;
    private final Font labelFont;
    private final Image[] images;
    private String fileName = "...";
    private String timeRemain = "...";
    private String speed = "...";

    public FileDownloading(ThemeManager themeManager, PanelUpdate parent) {
        this.themeManager = themeManager;
        this.labelFont = LocalResourceHelper.loadFont("GolosText-Regular", 14.0f);
        this.images = this.loadImages();
        this.setBounds(0, parent.getHeight() - 74 - 24 - 34, parent.getWidth(), 74);
        this.setVisible(false);
    }

    private Image[] loadImages() {
        return new Image[]{this.themeManager.getImage("icons", "file", 18, 18), this.themeManager.getImage("icons", "time", 18, 18), this.themeManager.getImage("icons", "speed", 18, 18)};
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        this.drawLabel(g2d, this.images[0], this.themeManager.getColor("sub-title"), this.fileName, 0);
        this.drawLabel(g2d, this.images[1], this.themeManager.getColor("sub-title"), this.timeRemain, 28);
        this.drawLabel(g2d, this.images[2], this.themeManager.getColor("sub-title"), this.speed, 56);
    }

    private void drawLabel(Graphics2D g2d, Image icon, Color color, String text, int posY) {
        g2d.setPaint(color);
        g2d.setFont(this.labelFont);
        int imageWidth = icon.getWidth(this);
        int imageHeight = icon.getHeight(this);
        int stringWidth = g2d.getFontMetrics().stringWidth(text) - imageWidth;
        int labelPosX = this.getWidth() / 2 - stringWidth / 2 - imageWidth;
        g2d.drawString(text, labelPosX + imageWidth + 6, posY + 14);
        g2d.drawImage(icon, labelPosX, posY, imageWidth, imageHeight, this);
    }

    public void setFileName(String value) {
        this.fileName = value;
        this.repaint();
    }

    public void setTimeRemain(String value) {
        this.timeRemain = value;
        this.repaint();
    }

    public void setSpeed(String value) {
        this.speed = value;
        this.repaint();
    }
}

