/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.bootstrap.service.gui.component.widget;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.Timer;
import ru.smclabs.bootstrap.service.gui.ThemeManager;
import ru.smclabs.bootstrap.service.gui.panel.PanelUpdate;

public class ProgressBar
extends JComponent {
    private final ThemeManager themeManager;
    private double progress;
    private double bouncePos;
    private double bounceSpeed = 0.02;
    private Timer bounceTimer;
    private volatile boolean bounceMode;

    public ProgressBar(ThemeManager themeManager, PanelUpdate parent) {
        this.themeManager = themeManager;
        this.setBounds(0, parent.getHeight() - 24, parent.getWidth(), 24);
        this.setProgress(-1.0);
    }

    public void setProgress(double value) {
        if (value < 0.0) {
            this.startBounce();
        } else {
            this.stopBounce();
            this.progress = Math.min(1.0, Math.max(0.035, value));
            this.repaint();
        }
    }

    private void startBounce() {
        if (this.bounceMode) {
            return;
        }
        this.bounceMode = true;
        this.bouncePos = 0.0;
        this.bounceTimer = new Timer(8, e -> {
            this.bouncePos += this.bounceSpeed;
            if (this.bouncePos < 0.0) {
                this.bouncePos = 0.0;
                this.bounceSpeed = -this.bounceSpeed;
            } else if (this.bouncePos > 1.0) {
                this.bouncePos = 1.0;
                this.bounceSpeed = -this.bounceSpeed;
            }
            this.repaint();
        });
        this.bounceTimer.start();
    }

    private void stopBounce() {
        if (this.bounceTimer != null) {
            this.bounceMode = false;
            this.bounceTimer.stop();
            this.bounceTimer = null;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        Rectangle bounds = this.getBounds();
        this.drawBackground(g2d, bounds);
        if (this.bounceMode) {
            this.drawBounce(g2d, bounds);
        } else {
            this.drawProgress(g2d, bounds);
        }
        g2d.dispose();
    }

    private void drawBackground(Graphics2D g2d, Rectangle bounds) {
        g2d.setColor(this.themeManager.getColor("progress-bar"));
        g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), this.getHeight(), this.getHeight()));
    }

    private void drawProgress(Graphics2D g2d, Rectangle bounds) {
        g2d.setColor(this.themeManager.getColor("progress-bar-track"));
        g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, (double)this.getWidth() * this.progress, this.getHeight(), this.getHeight(), this.getHeight()));
    }

    private void drawBounce(Graphics2D g2d, Rectangle bounds) {
        double barWidth = (double)this.getWidth() * 0.2;
        double barPosX = ((double)this.getWidth() - barWidth) * this.bouncePos;
        g2d.setColor(this.themeManager.getColor("progress-bar-track"));
        g2d.fill(new RoundRectangle2D.Double(barPosX, 0.0, barWidth, this.getHeight(), this.getHeight(), this.getHeight()));
    }
}

