/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.bootstrap.service.gui.panel;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import ru.smclabs.bootstrap.Bootstrap;
import ru.smclabs.bootstrap.service.GuiService;
import ru.smclabs.bootstrap.service.gui.component.widget.FileDownloading;
import ru.smclabs.bootstrap.service.gui.component.widget.ProgressBar;
import ru.smclabs.bootstrap.service.gui.panel.AbstractPanel;
import ru.smclabs.bootstrap.util.LocalResourceHelper;

public class PanelUpdate
extends AbstractPanel {
    public static final int VERTICAL_GAP = 34;
    private final Font titleFont;
    private final Font subTitleFont;
    private final FileDownloading fileDownloading;
    private final ProgressBar progressBar;
    private String labelTitle = "\u041f\u043e\u0438\u0441\u043a \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439";
    private String labelSubTitle = "\u044d\u0442\u043e \u0437\u0430\u0439\u043c\u0435\u0442 \u043f\u0430\u0440\u0443 \u043c\u0433\u043d\u043e\u0432\u0435\u043d\u0438\u0439...";

    public PanelUpdate(GuiService guiService) {
        super(guiService);
        int posY = 102;
        this.setBounds(34, posY, this.calcWidth(), this.calcHeight(posY));
        this.setBackground(null);
        this.setLayout(null);
        this.titleFont = LocalResourceHelper.loadFont("GolosText-Bold", 34.0f);
        this.subTitleFont = LocalResourceHelper.loadFont("GolosText-Regular", 16.0f);
        this.fileDownloading = new FileDownloading(guiService.getThemeManager(), this);
        this.add(this.fileDownloading);
        this.progressBar = new ProgressBar(guiService.getThemeManager(), this);
        this.add(this.progressBar);
    }

    private int calcWidth() {
        return this.guiService.getBootstrap().getEnvironment().getGui().getFrameWidth() - 68;
    }

    private int calcHeight(int posY) {
        return Bootstrap.getInstance().getEnvironment().getGui().getFrameHeight() - posY - 28;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawBackground(g2d);
        this.drawCenteredString(g2d, this.labelTitle, this.titleFont, this.guiService.getThemeManager().getColor("title"), 25);
        this.drawCenteredString(g2d, this.labelSubTitle, this.subTitleFont, this.guiService.getThemeManager().getColor("sub-title"), 49);
    }

    private void drawBackground(Graphics2D g2d) {
        g2d.setColor(this.guiService.getThemeManager().getColor("bg"));
        g2d.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    public void drawCenteredString(Graphics2D g2d, String text, Font font, Paint paint, int y) {
        g2d.setPaint(paint);
        g2d.setFont(font);
        g2d.drawString(text, this.getWidth() / 2 - g2d.getFontMetrics().stringWidth(text) / 2, y);
    }

    public void setLabelTitle(String text) {
        this.labelTitle = text;
        this.repaint();
    }

    public void setLabelSubTitle(String text) {
        this.labelSubTitle = text;
        this.repaint();
    }

    public void setProgress(double progress) {
        this.progressBar.setProgress(progress);
    }

    public void setLabelTimeRemain(String time) {
        this.fileDownloading.setTimeRemain(time);
    }

    public void setLabelSpeed(String speed) {
        this.fileDownloading.setSpeed(speed);
    }

    public void setLabelFileName(String fileName) {
        this.fileDownloading.setFileName(fileName);
    }

    public void setFileDownloadingVisible(boolean visible) {
        this.fileDownloading.setVisible(visible);
        this.repaint();
    }
}

