/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.bootstrap.service.launcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import ru.smclabs.bootstrap.Bootstrap;
import ru.smclabs.bootstrap.service.launcher.exception.LauncherServiceException;
import ru.smclabs.bootstrap.service.launcher.process.LauncherProcess;
import ru.smclabs.bootstrap.service.resource.type.ResourceLauncher;
import ru.smclabs.slauncher.resources.provider.DirProvider;
import ru.smclabs.slauncher.resources.type.ResourceCompressedRuntime;
import ru.smclabs.slauncher.util.logger.ILogger;

public class ProcessManager {
    private static final BiPredicate<Path, BasicFileAttributes> PROCESS_FILE_FILTER = (path, attributes) -> attributes.isRegularFile() && path.getFileName().toString().endsWith(".json");
    private final ILogger logger;
    private final List<LauncherProcess> processes = new ArrayList<LauncherProcess>();

    public ProcessManager(ILogger logger) {
        this.logger = logger;
    }

    public LauncherProcess create(Path launcherPath, Path executableBinary) throws LauncherServiceException {
        DirProvider dirProvider = Bootstrap.getInstance().getDirProvider();
        LauncherProcess launcherProcess = new LauncherProcess(dirProvider, executableBinary);
        launcherProcess.addParam("-cp").addParam(launcherPath.toUri().getPath()).addParam("ru.smclabs.slauncher.SLauncherMain");
        launcherProcess.start(dirProvider);
        this.processes.add(launcherProcess);
        return launcherProcess;
    }

    private void destroyGameProcesses(ResourceCompressedRuntime runtime, ResourceLauncher launcher) {
        if (!Files.exists(runtime.getPath(), new LinkOption[0]) || !Files.exists(launcher.getPath(), new LinkOption[0])) {
            return;
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(runtime.getPath().toString());
        params.add("-cp");
        params.add(runtime.getPath().toUri().getPath());
        params.add("ru.smclabs.slauncher.SLauncherMain");
        params.add("--destroy-processes");
        ProcessBuilder builder = new ProcessBuilder(params);
        builder.directory(Bootstrap.getInstance().getDirProvider().getPersistenceDir().toFile());
        builder.redirectErrorStream(true);
        builder.environment().put("_JAVA_OPTIONS", "");
        try {
            Process process = builder.start();
            try (InputStreamReader isr = new InputStreamReader(process.getInputStream());){
                BufferedReader reader = new BufferedReader(isr);
                Throwable throwable = null;
                try {
                    String line = reader.readLine();
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                reader.close();
                            }
                        }
                        throw throwable3;
                    }
                }
            }
        }
        catch (Throwable e) {
            this.logger.error("Failed to destroy game processes!", e);
        }
    }

    public void destroyLauncherProcesses(ResourceCompressedRuntime runtime, ResourceLauncher launcher) {
        this.destroyGameProcesses(runtime, launcher);
        if (this.processes.isEmpty()) {
            return;
        }
        this.processes.forEach(process -> {
            try {
                process.destroy();
            }
            catch (LauncherServiceException e) {
                this.logger.error("Failed to destroy process", e);
            }
        });
        this.processes.clear();
    }

    public void readProcessesFromDisk() throws LauncherServiceException {
        this.processes.clear();
        DirProvider dirProvider = Bootstrap.getInstance().getDirProvider();
        try (Stream<Path> files = Files.find(dirProvider.getPersistenceDir("data/process/launcher"), 1, PROCESS_FILE_FILTER, new FileVisitOption[0]);){
            files.forEach(file -> {
                try {
                    this.processes.add(new LauncherProcess((Path)file));
                }
                catch (LauncherServiceException e) {
                    this.logger.error("Failed to read launcher process data!", e);
                }
            });
        }
        catch (IOException e) {
            throw new LauncherServiceException(e);
        }
    }
}

