/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.bootstrap.service.resource.download;

import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.net.ssl.SSLException;
import ru.smclabs.bootstrap.Bootstrap;
import ru.smclabs.bootstrap.service.resource.download.AfterDownloadAction;
import ru.smclabs.bootstrap.service.resource.download.ResourceDownloadTaskStats;
import ru.smclabs.bootstrap.service.resource.exception.ResourceNotCompleteException;
import ru.smclabs.bootstrap.service.resource.exception.ResourceServerException;
import ru.smclabs.bootstrap.service.resource.exception.ResourceWriteException;
import ru.smclabs.slauncher.http.HttpService;
import ru.smclabs.slauncher.http.environment.HttpEnvironment;
import ru.smclabs.slauncher.http.exception.HttpClientException;
import ru.smclabs.slauncher.http.exception.HttpServiceException;
import ru.smclabs.slauncher.resources.exception.ResourceException;
import ru.smclabs.slauncher.resources.type.Resource;
import ru.smclabs.slauncher.resources.util.FileUtils;
import ru.smclabs.slauncher.util.logger.ILogger;

public class ResourceDownloadTask {
    private final Resource resource;
    private final Path tempPath;
    private ResourceDownloadTaskStats stats;

    public ResourceDownloadTask(Resource resource) {
        this.resource = resource;
        this.tempPath = Paths.get(resource.getPath() + ".download", new String[0]);
    }

    public void run() throws ResourceWriteException, InterruptedException {
        this.prepareDir();
        try {
            this.downloadWithRetry(false);
        }
        catch (ResourceNotCompleteException e) {
            int errors = 0;
            while (true) {
                Bootstrap.getInstance().getLogger().info("Retry #" + errors + " file downloading: " + this.resource.getUrl(), new Object[0]);
                try {
                    this.downloadWithRetry(true);
                }
                catch (ResourceNotCompleteException exception) {
                    if (errors++ != 10) continue;
                    throw new ResourceNotCompleteException(this.resource, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b: " + exception.getResource().getName());
                }
                break;
            }
        }
        if (this.resource instanceof AfterDownloadAction) {
            ((AfterDownloadAction)((Object)this.resource)).afterDownload();
        }
    }

    private void prepareDir() {
        try {
            Files.createDirectories(this.tempPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    private void downloadWithRetry(boolean append) throws ResourceWriteException, InterruptedException {
        HttpService httpService = Bootstrap.getInstance().getHttpService();
        try {
            this.download(append);
        }
        catch (ResourceServerException | HttpClientException e) {
            HttpEnvironment environment = httpService.getEnvironment();
            ILogger logger = httpService.getLogger();
            logger.warn("Failed to send request to " + this.resource.getUrl() + "! (zone: ." + environment.getZone() + ", protocol: " + environment.getProtocol() + ")", new Object[0]);
            logger.info("Search working zone...", new Object[0]);
            for (int i = 0; i < environment.getZones().size(); ++i) {
                environment.setZoneIndex(i);
                for (int j = 0; j < environment.getProtocols().size(); ++j) {
                    environment.setProtocolIndex(j);
                    logger.info("Try zone: ." + environment.getZone() + ", protocol: " + environment.getProtocol(), new Object[0]);
                    try {
                        this.download(append);
                        logger.info("Found working zone: ." + environment.getZone() + ", protocol: " + environment.getProtocol(), new Object[0]);
                        return;
                    }
                    catch (ResourceServerException | HttpServiceException e1) {
                        e.addSuppressed(e1);
                        continue;
                    }
                }
            }
        }
    }

    private void download(boolean append) throws HttpClientException, ResourceServerException, ResourceWriteException, InterruptedException {
        block44: {
            HttpURLConnection connection = this.openConnection(append);
            try (BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());){
                try (FileOutputStream outputStream = new FileOutputStream(this.tempPath.toString(), append);){
                    byte[] buffer = new byte[1024];
                    do {
                        int bytesRead;
                        block43: {
                            try {
                                bytesRead = inputStream.read(buffer, 0, buffer.length);
                                if (bytesRead != -1) break block43;
                                break block44;
                            }
                            catch (SSLException e) {
                                throw new HttpClientException(e);
                            }
                            catch (IOException e) {
                                throw new ResourceServerException(e);
                            }
                        }
                        try {
                            outputStream.write(buffer, 0, bytesRead);
                        }
                        catch (IOException e) {
                            throw new ResourceWriteException(this.resource, (Throwable)e);
                        }
                        if (this.stats == null) continue;
                        this.stats.addReadBytes(bytesRead);
                    } while (!Thread.interrupted());
                    throw new InterruptedException("Resource download " + this.resource.getName() + " cancelled.");
                }
                catch (IOException e) {
                    throw new ResourceWriteException(this.resource, (Throwable)e);
                }
            }
            catch (IOException e) {
                throw new ResourceServerException(e);
            }
            finally {
                connection.disconnect();
            }
        }
        if (Files.notExists(this.tempPath, new LinkOption[0])) {
            throw new ResourceNotCompleteException(this.resource, "Resource not exists!");
        }
        try {
            if (Files.size(this.tempPath) < this.resource.getSize() && !this.resource.getName().endsWith(".js")) {
                throw new ResourceNotCompleteException(this.resource, "Files size not equals! (" + Files.size(this.tempPath) + " vs " + this.resource.getSize() + ")");
            }
        }
        catch (IOException e) {
            throw new ResourceNotCompleteException(this.resource, (Throwable)e);
        }
        try {
            FileUtils.atomicMove(this.tempPath, this.resource.getPath(), 10, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new ResourceException("Failed to move resource file!", e);
        }
    }

    private HttpURLConnection openConnection(boolean append) throws HttpClientException, ResourceServerException {
        int responseCode;
        HttpService httpService = Bootstrap.getInstance().getHttpService();
        URL url = httpService.createUrl(this.resource.getUrl());
        HttpURLConnection connection = httpService.openConnection(url, "GET");
        if (append) {
            try {
                connection.setRequestProperty("Range", "bytes=" + Files.size(this.tempPath) + "-" + this.resource.getSize());
            }
            catch (IOException e) {
                throw new ResourceException("Failed to check temp file size!", e);
            }
        }
        try {
            responseCode = connection.getResponseCode();
        }
        catch (IOException e) {
            throw new ResourceServerException("Failed to get response code from server!", e);
        }
        if (responseCode == 416) {
            try {
                Files.deleteIfExists(this.tempPath);
            }
            catch (IOException e) {
                throw new ResourceException("Failed to remove temp file!", e);
            }
            return httpService.openConnection(url, "GET");
        }
        return connection;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setStats(ResourceDownloadTaskStats stats) {
        this.stats = stats;
    }
}

