/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.bootstrap.util;

import java.text.SimpleDateFormat;
import java.util.concurrent.TimeUnit;
import ru.smclabs.bootstrap.util.StringUtils;

public class TimeUtils {
    private static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("dd.MM.yyyy' 'HH:mm");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy");

    public static String toHumanTime(long timestamp) {
        return TimeUtils.toHumanTime(timestamp, false);
    }

    public static String toHumanTime(long timestamp, boolean shortTypes) {
        long days = TimeUnit.MILLISECONDS.toDays(timestamp);
        long hours = TimeUnit.MILLISECONDS.toHours(timestamp) - TimeUnit.DAYS.toHours(days);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(timestamp) - TimeUnit.DAYS.toMinutes(days) - TimeUnit.HOURS.toMinutes(hours);
        long seconds = TimeUnit.MILLISECONDS.toSeconds(timestamp) - TimeUnit.DAYS.toSeconds(days) - TimeUnit.HOURS.toSeconds(hours) - TimeUnit.MINUTES.toSeconds(minutes);
        StringBuilder builder = new StringBuilder();
        if (days > 0L) {
            builder.append(days).append(StringUtils.dependName(days, shortTypes ? "\u0434." : " \u0434\u0435\u043d\u044c", shortTypes ? "\u0434." : " \u0434\u043d\u044f", shortTypes ? "\u0434." : " \u0434\u043d\u0435\u0439"));
        }
        if (hours > 0L) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(hours).append(StringUtils.dependName(hours, shortTypes ? "\u0447." : " \u0447\u0430\u0441", shortTypes ? "\u0447." : " \u0447\u0430\u0441\u0430", shortTypes ? "\u0447." : " \u0447\u0430\u0441\u043e\u0432"));
        }
        if (minutes > 0L && days == 0L) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(minutes).append(StringUtils.dependName(minutes, shortTypes ? "\u043c." : " \u043c\u0438\u043d\u0443\u0442\u0430", shortTypes ? "\u043c." : " \u043c\u0438\u043d\u0443\u0442\u044b", shortTypes ? "\u043c." : " \u043c\u0438\u043d\u0443\u0442"));
        }
        if (seconds > 0L && days == 0L && hours == 0L) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(seconds).append(StringUtils.dependName(seconds, shortTypes ? "\u0441." : " \u0441\u0435\u043a\u0443\u043d\u0434\u0430", shortTypes ? "\u0441." : " \u0441\u0435\u043a\u0443\u043d\u0434\u044b", shortTypes ? "\u0441." : " \u0441\u0435\u043a\u0443\u043d\u0434"));
        }
        if (days == 0L && hours == 0L && minutes == 0L && seconds == 0L) {
            builder.append("0").append(shortTypes ? "\u0441" : " \u0441\u0435\u043a\u0443\u043d\u0434");
        }
        return builder.toString();
    }

    public static String toHumanTimeOrDate(Long timestamp) {
        long timeAfterRealise = System.currentTimeMillis() - timestamp;
        return timeAfterRealise > 2592000000L ? TimeUtils.toDateTime(timestamp) : TimeUtils.toHumanTime(timeAfterRealise) + " \u043d\u0430\u0437\u0430\u0434";
    }

    public static String toDateTime(long timestamp) {
        return DATE_TIME_FORMAT.format(timestamp);
    }

    public static String toDate(long timestamp) {
        return DATE_FORMAT.format(timestamp);
    }
}

