/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.jacksonpack.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import ru.smclabs.jacksonpack.Jackson;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class JacksonConfig {
    @JsonIgnore
    private Path path;

    public JacksonConfig(Path path) {
        this.path = path;
    }

    public void writeToDisk() throws IOException {
        if (!Files.exists(this.path.getParent(), new LinkOption[0])) {
            Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
        }
        Jackson.getMapper().writerWithDefaultPrettyPrinter().writeValue(this.path.toFile(), (Object)this);
    }

    public void readFromDisk() throws IOException {
        if (!Files.exists(this.path, new LinkOption[0])) {
            this.writeToDisk();
        }
        JacksonConfig config = (JacksonConfig)Jackson.getMapper().readValue(this.path.toFile(), this.getClass());
        Arrays.stream(config.getClass().getDeclaredFields()).filter(field -> field.getAnnotation(JsonProperty.class) != null).peek(field -> field.setAccessible(true)).forEach(field -> {
            try {
                Field configField = this.getClass().getDeclaredField(field.getName());
                configField.setAccessible(true);
                configField.set(this, field.get(config));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        });
    }

    public JacksonConfig() {
    }
}

