/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.slauncher.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import lombok.Generated;
import ru.smclabs.slauncher.http.environment.HttpEnvironment;
import ru.smclabs.slauncher.http.exception.HttpClientException;
import ru.smclabs.slauncher.util.logger.ILogger;

public class HttpService {
    protected final HttpEnvironment environment;
    protected final ILogger logger;

    public HttpService(HttpEnvironment environment, ILogger logger) {
        this.environment = environment;
        this.logger = logger;
    }

    protected String preparePath(String path) {
        return path.replace(this.environment.getHostnameKey(), this.environment.getHostname()).replace("%zone%", this.environment.getZone());
    }

    public URL createUrl(String path) throws HttpClientException {
        try {
            path = this.preparePath(path);
            return new URL(this.environment.getProtocol() + path);
        }
        catch (MalformedURLException e) {
            throw new HttpClientException("Failed to create URL for path" + path, e);
        }
    }

    public HttpURLConnection openConnection(URL url, String method) throws HttpClientException {
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setUseCaches(false);
            connection.setRequestMethod(method);
            connection.setRequestProperty("User-Agent", this.environment.getUserAgent());
            return connection;
        }
        catch (IOException e) {
            throw new HttpClientException("Failed to open connection!", e);
        }
    }

    @Generated
    public HttpEnvironment getEnvironment() {
        return this.environment;
    }

    @Generated
    public ILogger getLogger() {
        return this.logger;
    }
}

