/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.slauncher.http.environment;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public class HttpEnvironment {
    private final List<String> zones;
    private final List<String> protocols;
    private final String userAgent;
    private final String hostname;
    private final String hostnameKey;
    private volatile int zoneIndex;
    private volatile int protocolIndex;

    public HttpEnvironment(List<String> zones, String userAgent, String hostname, String hostnameKey) {
        this(zones, Arrays.asList("https://", "http://"), userAgent, hostname, hostnameKey);
    }

    public HttpEnvironment(List<String> zones, List<String> protocols, String userAgent, String hostname, String hostnameKey) {
        this.zones = zones;
        this.protocols = protocols;
        this.userAgent = userAgent;
        this.hostname = hostname;
        this.hostnameKey = hostnameKey;
        this.setZoneIndex(0);
        this.setProtocolIndex(0);
    }

    public synchronized void setZoneIndex(int zoneIndex) {
        if (this.zones == null) {
            throw new IllegalStateException("Zones collection is not initialized");
        }
        if (this.zones.isEmpty()) {
            throw new IllegalStateException("Zones collection is empty");
        }
        if (zoneIndex < 0 || zoneIndex >= this.zones.size()) {
            throw new IllegalArgumentException("Zone index must be between 0 and " + (this.zones.size() - 1));
        }
        this.zoneIndex = zoneIndex;
        System.setProperty("slauncher.http.zone", this.getZone());
    }

    public synchronized void setProtocolIndex(int protocolIndex) {
        if (this.protocols == null) {
            throw new IllegalStateException("Protocols collection is not initialized");
        }
        if (this.protocols.isEmpty()) {
            throw new IllegalStateException("Protocols collection is empty");
        }
        if (protocolIndex < 0 || protocolIndex >= this.protocols.size()) {
            throw new IllegalArgumentException("Protocol index must be between 0 and " + (this.protocols.size() - 1));
        }
        this.protocolIndex = protocolIndex;
        System.setProperty("slauncher.http.protocol", this.getProtocol());
    }

    public String getHostname() {
        return this.hostname.replace("%zone%", this.getZone());
    }

    public String getProtocol() {
        return this.protocols.get(this.protocolIndex);
    }

    public String getZone() {
        return this.zones.get(this.zoneIndex);
    }

    @Generated
    public List<String> getZones() {
        return this.zones;
    }

    @Generated
    public List<String> getProtocols() {
        return this.protocols;
    }

    @Generated
    public String getUserAgent() {
        return this.userAgent;
    }

    @Generated
    public String getHostnameKey() {
        return this.hostnameKey;
    }

    @Generated
    public int getZoneIndex() {
        return this.zoneIndex;
    }

    @Generated
    public int getProtocolIndex() {
        return this.protocolIndex;
    }

    @Generated
    public String toString() {
        return "HttpEnvironment(zones=" + this.getZones() + ", protocols=" + this.getProtocols() + ", userAgent=" + this.getUserAgent() + ", hostname=" + this.getHostname() + ", hostnameKey=" + this.getHostnameKey() + ", zoneIndex=" + this.getZoneIndex() + ", protocolIndex=" + this.getProtocolIndex() + ")";
    }
}

