/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.slauncher.http.request;

import com.fasterxml.jackson.core.type.TypeReference;
import java.awt.image.BufferedImage;
import java.net.HttpURLConnection;
import ru.smclabs.slauncher.http.HttpService;
import ru.smclabs.slauncher.http.exception.HttpAuthException;
import ru.smclabs.slauncher.http.exception.HttpServerException;
import ru.smclabs.slauncher.http.exception.HttpServiceException;
import ru.smclabs.slauncher.http.request.HttpRequest;
import ru.smclabs.slauncher.http.response.HttpResponseImage;
import ru.smclabs.slauncher.util.logger.ILogger;

public class HttpRequestImage<S extends HttpService>
extends HttpRequest<S, BufferedImage> {
    public HttpRequestImage(S httpService, String path) {
        super(httpService, "GET", "image/png", path);
    }

    @Override
    public BufferedImage execute(TypeReference<BufferedImage> typeReference) throws HttpServiceException {
        return this.execute();
    }

    @Override
    public BufferedImage execute(Class<BufferedImage> responseClass) throws HttpServiceException {
        return this.execute();
    }

    public BufferedImage execute() throws HttpServiceException {
        HttpResponseImage responseImage = (HttpResponseImage)super.sendRequestWithRetry();
        return responseImage.getImage();
    }

    @Override
    protected HttpResponseImage sendRequest(ILogger logger) throws HttpServiceException {
        HttpURLConnection connection = this.openConnection(this.prepareURL());
        this.writeRequestBody(connection);
        HttpResponseImage response = new HttpResponseImage(connection);
        response.readStream();
        if (response.getResponseCode() == 200) {
            return response;
        }
        if (response.getResponseCode() == 401) {
            throw new HttpAuthException(response);
        }
        throw new HttpServerException(response);
    }
}

