/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.slauncher.model.game.server;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ServerMonitor {
    protected int players;
    protected int playersMax;

    @JsonIgnore
    public double getFillPercent() {
        return (double)this.players / (double)this.playersMax;
    }

    @JsonIgnore
    public boolean isOffline() {
        return this.playersMax < 1;
    }

    @JsonIgnore
    public boolean isOnline() {
        return !this.isOffline();
    }

    public int getPlayers() {
        return this.players;
    }

    public int getPlayersMax() {
        return this.playersMax;
    }

    public void setPlayers(int players) {
        this.players = players;
    }

    public void setPlayersMax(int playersMax) {
        this.playersMax = playersMax;
    }

    public String toString() {
        return "ServerMonitor(players=" + this.getPlayers() + ", playersMax=" + this.getPlayersMax() + ")";
    }

    public ServerMonitor() {
    }

    public ServerMonitor(int players, int playersMax) {
        this.players = players;
        this.playersMax = playersMax;
    }
}

