/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.slauncher.model.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import ru.smclabs.slauncher.model.game.client.ClientModel;
import ru.smclabs.slauncher.model.user.group.UserGroup;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AuthoritiesContainer {
    private UserGroup primaryGroup;
    private List<UserGroup> authorities = Collections.emptyList();

    public List<UserGroup> getGroupsAtClient(ClientModel client) {
        return this.getGroupsAtClient(client.getName());
    }

    public List<UserGroup> getGroupsAtClient(String client) {
        String clientName = client.toLowerCase();
        return this.authorities.stream().filter(group -> AuthoritiesContainer.filterByClient(group, clientName)).collect(Collectors.toList());
    }

    public boolean hasPermissionLevelAtClient(ClientModel client, int level) {
        return this.getGroupsAtClient(client).stream().anyMatch(group -> AuthoritiesContainer.filterLevel(group, level));
    }

    public boolean hasPermissionLevelAtClient(String client, int level) {
        return this.getGroupsAtClient(client).stream().anyMatch(group -> AuthoritiesContainer.filterLevel(group, level));
    }

    public boolean hasPermissionLevel(int level) {
        return this.authorities.stream().anyMatch(group -> AuthoritiesContainer.filterLevel(group, level));
    }

    @JsonIgnore
    public AuthoritiesContainer toAuthorities() {
        AuthoritiesContainer container = new AuthoritiesContainer();
        container.authorities = this.authorities;
        container.primaryGroup = this.primaryGroup;
        return container;
    }

    private static boolean filterByClient(UserGroup group, String client) {
        return group.getServer().equals("all") || group.getServer().toLowerCase().startsWith(client);
    }

    private static boolean filterLevel(UserGroup group, int level) {
        return group.getPermissionLevel() >= level;
    }

    public UserGroup getPrimaryGroup() {
        return this.primaryGroup;
    }

    public List<UserGroup> getAuthorities() {
        return this.authorities;
    }

    public void setPrimaryGroup(UserGroup primaryGroup) {
        this.primaryGroup = primaryGroup;
    }

    public void setAuthorities(List<UserGroup> authorities) {
        this.authorities = authorities;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthoritiesContainer)) {
            return false;
        }
        AuthoritiesContainer other = (AuthoritiesContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UserGroup this$primaryGroup = this.getPrimaryGroup();
        UserGroup other$primaryGroup = other.getPrimaryGroup();
        if (this$primaryGroup == null ? other$primaryGroup != null : !((Object)this$primaryGroup).equals(other$primaryGroup)) {
            return false;
        }
        List<UserGroup> this$authorities = this.getAuthorities();
        List<UserGroup> other$authorities = other.getAuthorities();
        return !(this$authorities == null ? other$authorities != null : !((Object)this$authorities).equals(other$authorities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthoritiesContainer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UserGroup $primaryGroup = this.getPrimaryGroup();
        result = result * 59 + ($primaryGroup == null ? 43 : ((Object)$primaryGroup).hashCode());
        List<UserGroup> $authorities = this.getAuthorities();
        result = result * 59 + ($authorities == null ? 43 : ((Object)$authorities).hashCode());
        return result;
    }

    public String toString() {
        return "AuthoritiesContainer(primaryGroup=" + this.getPrimaryGroup() + ", authorities=" + this.getAuthorities() + ")";
    }

    public AuthoritiesContainer() {
    }

    public AuthoritiesContainer(UserGroup primaryGroup, List<UserGroup> authorities) {
        this.primaryGroup = primaryGroup;
        this.authorities = authorities;
    }
}

