/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.slauncher.resources.atomic;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.SecureRandom;
import java.util.Objects;
import ru.smclabs.slauncher.resources.exception.ResourceException;
import ru.smclabs.slauncher.resources.util.FileUtils;

public class AtomicFileWriter {
    private final Path path;
    private final Path pathToWrite;

    private AtomicFileWriter(Path path) {
        this.path = path;
        this.pathToWrite = path.getParent().resolve(this.getWriteName());
    }

    private String getWriteName() {
        return new BigInteger(130, new SecureRandom()).toString(32);
    }

    public static void write(Path path, String value) {
        AtomicFileWriter.write(path, StandardCharsets.UTF_8, value);
    }

    public static void write(Path path, Charset charset, String value) {
        AtomicFileWriter.write(path, Objects.requireNonNull(value, "value cannot be null").getBytes(charset));
    }

    public static void write(Path path, byte[] bytes) throws ResourceException {
        AtomicFileWriter writer = new AtomicFileWriter(path);
        try {
            Files.write(writer.pathToWrite, bytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            FileUtils.atomicMove(writer.pathToWrite, writer.path, 5, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new ResourceException("Failed to atomic file write! (" + writer.path.getFileName().toString() + ")", e);
        }
    }

    public Path getPath() {
        return this.path;
    }

    public Path getPathToWrite() {
        return this.pathToWrite;
    }
}

