/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.slauncher.resources.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.smclabs.jacksonpack.Jackson;
import ru.smclabs.slauncher.resources.atomic.AtomicFileWriter;
import ru.smclabs.slauncher.resources.exception.ResourceException;
import ru.smclabs.slauncher.resources.factory.ResourcesFactory;
import ru.smclabs.slauncher.resources.mapper.ResourceMapperEntry;
import ru.smclabs.slauncher.resources.provider.DirProvider;

public class ResourceMapper {
    private static final TypeReference<ArrayList<ResourceMapperEntry>> TYPE_REFERENCE = new TypeReference<ArrayList<ResourceMapperEntry>>(){

        @Override
        public Type getType() {
            return super.getType();
        }
    };
    private final Path path;
    private final String id;
    private final Map<Path, String> entries = new HashMap<Path, String>();

    public ResourceMapper(ResourcesFactory factory, String id) {
        this(factory.getDirProvider(), id);
    }

    public ResourceMapper(DirProvider dirProvider, String id) {
        this.id = id;
        this.path = dirProvider.getPersistenceDir("data/mapper").resolve(id + ".json");
    }

    public void put(Path path, Object data) {
        this.entries.put(path, String.valueOf(data));
    }

    public void clear() {
        this.entries.clear();
    }

    public boolean contains(Path entryPath, Object entryValue) {
        String entry = this.entries.get(entryPath);
        return entry != null && entry.equals(String.valueOf(entryValue));
    }

    public List<ResourceMapperEntry> getEntries() {
        ArrayList<ResourceMapperEntry> list = new ArrayList<ResourceMapperEntry>();
        this.entries.forEach((path, entry) -> list.add(new ResourceMapperEntry((Path)path, (String)entry)));
        return list;
    }

    public void writeToDisk() {
        if (!Files.exists(this.path.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ResourceException(e);
            }
        }
        try {
            AtomicFileWriter.write(this.path, this.toJson());
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public void readFromDisk() {
        if (Files.notExists(this.path, new LinkOption[0])) {
            this.writeToDisk();
            return;
        }
        this.entries.clear();
        for (ResourceMapperEntry entry : this.fromJson()) {
            this.entries.put(entry.getPath(), String.valueOf(entry.getData()));
        }
    }

    private List<ResourceMapperEntry> fromJson() {
        try {
            return Jackson.getMapper().readValue(this.path.toFile(), TYPE_REFERENCE);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private String toJson() throws JsonProcessingException {
        return Jackson.getMapper().writeValueAsString(this.getEntries());
    }

    public Path getPath() {
        return this.path;
    }

    public String getId() {
        return this.id;
    }
}

