/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.slauncher.resources.provider;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import ru.smclabs.slauncher.resources.exception.DirectoryException;
import ru.smclabs.slauncher.resources.provider.DirEnvironment;

public class DirProvider {
    protected final Path persistenceDir;
    protected final Path logsDir;

    public DirProvider(DirEnvironment environment) {
        this.persistenceDir = this.createPersistenceDir(environment);
        this.logsDir = this.getPersistenceDir("logs");
    }

    protected Path createPersistenceDir(DirEnvironment environment) {
        Path rootDir;
        if (System.getProperty("os.name", "").toLowerCase().contains("win")) {
            String envDir = System.getenv("AppData");
            if (envDir == null) {
                envDir = System.getProperty("user.home", ".");
            }
            if ((rootDir = Paths.get(envDir, new String[0])).toString().contains("!")) {
                rootDir = Paths.get(System.getenv("SystemDrive"), new String[0]);
            }
        } else {
            rootDir = Paths.get(System.getProperty("user.home", "."), new String[0]);
        }
        return this.createDir(rootDir.resolve(environment.getPersistenceDir()));
    }

    public Path getPersistenceDir(String dirPath) {
        return this.createDir(this.persistenceDir.resolve(dirPath));
    }

    protected Path createDir(Path dir) throws DirectoryException {
        if (Files.notExists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new DirectoryException("Failed to create dir: " + dir, e);
            }
        }
        return dir;
    }

    public Path getPersistenceDir() {
        return this.persistenceDir;
    }

    public Path getLogsDir() {
        return this.logsDir;
    }

    public String toString() {
        return "DirProvider(persistenceDir=" + this.getPersistenceDir() + ", logsDir=" + this.getLogsDir() + ")";
    }
}

