/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.slauncher.resources.type;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import ru.smclabs.slauncher.model.resource.ResourceModel;
import ru.smclabs.slauncher.resources.factory.ResourcesFactory;
import ru.smclabs.slauncher.resources.type.ResourceStruct;
import ru.smclabs.slauncher.resources.util.FileUtils;

public class Resource
extends ResourceStruct {
    private String url;

    public Resource(ResourcesFactory factory, ResourceModel model) {
        super(factory, model);
        this.url = factory.prepareUrl(model);
    }

    public boolean isInvalid() {
        return Files.notExists(this.path, new LinkOption[0]) || FileUtils.size(this.path) != this.size;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String toString() {
        return "Resource(url=" + this.getUrl() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Resource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }
}

