/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.slauncher.util.logger;

import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import ru.smclabs.slauncher.util.logger.ILogger;
import ru.smclabs.slauncher.util.logger.formatter.IThrowableFormatter;
import ru.smclabs.slauncher.util.logger.formatter.ThrowablePrinter;
import ru.smclabs.slauncher.util.logger.impl.LoggerImpl;

public class LoggerFactory {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    private static final List<IThrowableFormatter> THROWABLE_FORMATTERS = new ArrayList<IThrowableFormatter>();
    private static final Formatter FORMATTER = new Formatter(){
        private final Calendar calendar = new GregorianCalendar();

        @Override
        public String format(LogRecord record) {
            this.calendar.setTimeInMillis(record.getMillis());
            return DATE_FORMAT.format(this.calendar.getTime()) + " [" + record.getLevel() + "]: " + record.getMessage() + "\n" + LoggerFactory.throwableAsString(record.getThrown());
        }
    };

    public static void addThrowableFormatter(IThrowableFormatter formatter) {
        THROWABLE_FORMATTERS.add(formatter);
    }

    public static ILogger create(Path dir, String name) {
        Logger logger = LogManager.getLogManager().getLogger("");
        for (Handler handler : logger.getHandlers()) {
            handler.setFormatter(FORMATTER);
        }
        try {
            FileHandler fileHandler = LoggerFactory.createFileHandler(Paths.get(dir.toString(), name + ".log"));
            logger.addHandler(fileHandler);
        }
        catch (IOException | SecurityException e) {
            logger.log(Level.SEVERE, "Failed to create FileHandler!", e);
        }
        return new LoggerImpl(logger);
    }

    private static FileHandler createFileHandler(Path path) throws IOException {
        Path parentDir = path.getParent();
        if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        FileHandler fileHandler = new FileHandler(path.toString(), true);
        fileHandler.setFormatter(FORMATTER);
        return fileHandler;
    }

    public static String throwableAsString(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter buffer = new StringWriter();
        THROWABLE_FORMATTERS.forEach(formatter -> formatter.format(buffer, e));
        return buffer.toString();
    }

    static {
        LoggerFactory.addThrowableFormatter(new ThrowablePrinter());
    }
}

