/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.system.process;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import ru.smclabs.system.exception.SystemException;
import ru.smclabs.system.process.id.IPidFetcher;
import ru.smclabs.system.process.id.PidFetcherNeo;
import ru.smclabs.system.process.id.PidFetcherUnix;
import ru.smclabs.system.process.id.PidFetcherWindows;

public class ProcessId {
    private static final List<IPidFetcher> fetchers = new ArrayList<IPidFetcher>();

    public static long self() throws SystemException {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String name = runtime.getName();
        if (name == null || name.isEmpty()) {
            throw new SystemException("Failed to get the process name (RuntimeMXBean returned null or an empty string).");
        }
        String[] parts = name.split("@");
        if (parts.length == 0 || parts[0].isEmpty()) {
            throw new SystemException("Invalid process name format: " + name);
        }
        try {
            return Long.parseLong(parts[0]);
        }
        catch (NumberFormatException e) {
            throw new SystemException("Failed to parse PID to a number: " + parts[0], e);
        }
    }

    public static long from(Process process) throws SystemException {
        Long pid = null;
        SystemException exception = new SystemException("Failed to get the pid from the process.");
        for (IPidFetcher fetcher : fetchers) {
            if (!fetcher.isSupported(process)) continue;
            try {
                pid = fetcher.getPid(process);
                break;
            }
            catch (SystemException e) {
                exception.addSuppressed(e);
            }
        }
        if (pid == null) {
            throw exception;
        }
        return pid;
    }

    static {
        fetchers.add(new PidFetcherNeo());
        fetchers.add(new PidFetcherUnix());
        fetchers.add(new PidFetcherWindows());
    }
}

