/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.system.process.id;

import java.lang.reflect.Field;
import ru.smclabs.system.exception.SystemException;
import ru.smclabs.system.process.id.IPidFetcher;

public class PidFetcherUnix
implements IPidFetcher {
    @Override
    public boolean isSupported(Process process) {
        return process.getClass().getName().equals("java.lang.UNIXProcess");
    }

    @Override
    public long getPid(Process process) throws SystemException {
        try {
            Field pidField = process.getClass().getDeclaredField("pid");
            pidField.setAccessible(true);
            try {
                return pidField.getLong(process);
            }
            catch (IllegalAccessException e) {
                throw new SystemException("Failed to access pid field", e);
            }
        }
        catch (NoSuchFieldException e) {
            throw new SystemException("Pid field not found", e);
        }
        catch (SecurityException e) {
            throw new SystemException("Access to pid field denied", e);
        }
    }
}

