/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.system.process.id;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.lang.reflect.Field;
import ru.smclabs.system.exception.SystemException;
import ru.smclabs.system.process.id.IPidFetcher;

public class PidFetcherWindows
implements IPidFetcher {
    @Override
    public boolean isSupported(Process process) {
        String className = process.getClass().getName();
        return className.equals("java.lang.Win32Process") || className.equals("java.lang.ProcessImpl");
    }

    @Override
    public long getPid(Process process) throws SystemException {
        return this.getPidFromHandleJna(this.getProcessHandle(process));
    }

    private long getProcessHandle(Process process) throws SystemException {
        try {
            Field handleField = process.getClass().getDeclaredField("handle");
            handleField.setAccessible(true);
            return handleField.getLong(process);
        }
        catch (Throwable e) {
            throw new SystemException("Failed to access handle field", e);
        }
    }

    private long getPidFromHandleJna(long handleId) throws SystemException {
        try {
            WinNT.HANDLE handle = new WinNT.HANDLE();
            handle.setPointer(Pointer.createConstant(handleId));
            return Kernel32.INSTANCE.GetProcessId(handle);
        }
        catch (Throwable e) {
            throw new SystemException("Failed to access GetProcessId in Kernel32", e);
        }
    }
}

